-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
require( "scripts/tittle_style.lua" )

HeaderFont = {
  standardFont,
  28,
  AquaColor
};

TableInfoFont = {
  standardFont,
  10,
 AquaColor
};

ErrorFont = {
  standardFont,
  24,
 AquaColor
};

AccountFont = {
  standardFont,
  16,
  DeepAquaColor
};

ScoreFont = {
  standardFont,
  14,
  AquaColor
};

HiscoreSubmitLegal = {
  standardFont,
  10,
  AquaColor
};

NameFontOrange = {
	standardFont,
	15,
	TittleAqua
};

kPlayerNameY = 70;
kScoreY = 100;
kYourPFAccountY = 130;
kAccountNameY = 160;
kPasswordY = 190;
kRememberY = 200;
kButtonY = kMax-125;

kPrivacyLabel = 'privacy';
if (IsEnabled(kHiscoreAnonymous)) then
	kPrivacyLabel = 'privacy_info';
end

function SwitchModes( submit )
	
	local localHS = IsEnabled(kHiscoreLocalOnly);
	local anonHS = IsEnabled(kHiscoreAnonymous);
	local fullHS = (not localHS) and (not anonHS);

	if submit then
		DebugOut( "SwitchModes true "..tostring(localHS).." "..tostring(anonHS));
	else
		DebugOut( "SwitchModes false "..tostring(localHS).." "..tostring(anonHS));
	end
	
	
	

--	EnableWindow("privacyanon", anonHS);
	
	

	EnableWindow("header",not submit);
	EnableWindow("headershadow",not submit);
	EnableWindow("playertext", not submit);
	EnableWindow("yourscore", not submit);
	EnableWindow("eligiblescore", not submit);
	EnableWindow("yourpfaccount", not submit and fullHS);
	EnableWindow("nametext", not submit and fullHS);
	EnableWindow("passtext", not submit and fullHS);

	EnableWindow("nameeditbox", not submit );
	EnableWindow("accounteditbox", not submit and fullHS);
	EnableWindow("passeditbox", not submit and fullHS);
	EnableWindow("remember", not submit and fullHS);

	EnableWindow("submittoserver", not submit);
	EnableWindow("submitcancel", not submit);
	EnableWindow("submitconnect", submit);

end

MakeDialog
{
	name="hiscoresubmitscreen",
	Bitmap
	{ 
		image="images/ui/common/popup02",	
		x=kCenter,
		y=kCenter,

		SetStyle(DefaultStyle);
		Text
		{
			font = HeaderFont,
			name = "header",
			x=0,y=30,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "submitglobal"
		};
		
		Text
		{
			font = AccountFont,
			name = "playertext",
			x=0,y=kPlayerNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "playerlabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "yourscore",
			x=90,y=kScoreY,w=142,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "scorelabel"
		};
		
		Text
		{
			font = PopupFont,
			name = "eligiblescore",
			x=205,y=kScoreY-5,w=100,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = GetBestScore(),
		};
		
		Text
		{
			font = NormalHelpFont,
			name = "yourpfaccount",
			x=90,y=kYourPFAccountY,w=kMax,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "yourpfaccount"
		};
		
		Text
		{
			font = AccountFont,
			name = "nametext",
			x=0,y=kAccountNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "namelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "passtext",
			x=0,y=kPasswordY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "passwordlabel"
		};
		
		Text
		{
			font = TableInfoFont,
			name = "submitconnect",
			x=kCenter,y=kCenter,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "connectingtoserver"
		};
		
		Text
		{
			font = ErrorFont,
			name = "submiterror",
			x=40,y=0,w=kMax-40,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Error Message"
		};
		
		Text
		{
			x = 20, w = kMax-20,
			y = 400, h = kMax,
			font = HiscoreSubmitLegal;
			flags = kHAlignLeft + kVAlignTop,
			label = kPrivacyLabel
		};

		Bitmap
		{
			name="nameeditbox",
			image="images/ui/buttons/box03",
			x=152,
			y=kPlayerNameY-5,
			
			TextEdit
			{
				font = NameFontOrange,
				name = "nameedit",
				label = gNameEdit,
				x=14,y=6,w=kMax,h=kMax,
				length=20,
				ignore = kIllegalNameChars
				
			};
		};
		
		Bitmap
		{
			name="accounteditbox",
			image="images/ui/buttons/box03",
			x=155,
			y=kAccountNameY-5,
			
			TextEdit
			{
				font = NameFontOrange,
				name = "accountedit",
				label= gAccountEdit,
				x=10,y=3,w=kMax,h=kMax,
				length=15,
				ignore = kIllegalNameChars
				
			};
		};
		
		Bitmap
		{
			name="passeditbox",
			image="images/ui/buttons/box03",
			x=155,
			y=kPasswordY-5,
			
			TextEdit
			{
				font = PopupFontOrange,
				name = "passedit",
				label= gPassEdit,
				x=10,y=3,w=kMax,h=kMax,
				password = true,
				length=15
				
			};
		};
		
		SetStyle(CheckboxButtonStyleFitness),
		Button
		{
			x=75, y=kRememberY,

			name="remember",
			type = kToggle,
			w=260,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg",
			
			Text
			{
				font = NormalHelpFont,
				name = "rememberlabel",
				x=55,
				y=30,
				w=250,
				h=15,
				flags = kHAlignLeft + kVAlignTop,
				label="rememberpfaccount",
			};
		};
		
		SetStyle(FitnessButtonStyleTittleSmallBlue2),
--Submit
		SBButton
		{
			x=kCenter-50,
			y=kButtonY,
			name="submittoserver",
			label="submit",
			icon="assets/images/ui/buttons/icon/iconok",
			default= true, -- this should be the default button (on enter)

			command = 
				function()
					name = GetLabel("nameedit");
					account = GetLabel("accountedit");
					pass = GetLabel("passedit");
					remember = GetButtonToggleState("remember");
					SubmitToServer(name,account,pass,remember);
				end
		},
		
--Cancel
		SBButton
		{
			x=kCenter+50,
			y=kButtonY,
			label = "common.cancel.label",
			icon="assets/images/ui/buttons/icon/iconcancel",
			command = 
				function()
					PopModal("hiscoresubmitscreen"); -- take off high score menu, restart game loop
				end
		};
		
		Text
		{
			font = HiscoreSubmitLegal,
			name = "privacyanon",
			x=kCenter,y=335,w=300 ,h=30,
			flags = kHAlignCenter+ kVAlignTop,
			label = "ui.dialog.highscores.global.anon.submit",
		};
		Button
		{
			x=0,
			y=100,
			w=0,
			h=0,
			graphics={},
			name="privacypolicy",
			command = 
				function()
					if (IsEnabled(kHiscoreAnonymous)) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="privacy_anon",
							title = ""
						};
					else
						LaunchPrivacyPolicy();
					end
				end
		};
	}
}

EnableWindow("submitconnect", false);
EnableWindow("submiterror",false);
EnableWindow("submiterrorok", false);
SetButtonToggleState('remember',gRemember);
SetFocus("nameedit");